/*
 * Decompiled with CFR 0.152.
 */
package com.vinlanx.gunfireoverhaul;

import com.vinlanx.gunfireoverhaul.ModSounds;
import com.vinlanx.gunfireoverhaul.PacketHandler;
import com.vinlanx.gunfireoverhaul.PlayTrackedSoundPacket;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;

public class ServerGunfireHandler {
    private static final double MIN_DISTANCE_TO_HEAR = 50.0;
    private static final double SPEED_OF_SOUND = 17.15;

    public static void handleGunfireEvent(Level level, LivingEntity shooter, Vec3 shooterPos, String caliberId) {
        if (level.m_5776_() || caliberId == null) {
            return;
        }
        boolean shooterInCave = ServerGunfireHandler.isInNaturalCave(level, shooter.m_20183_());
        for (ServerPlayer listener : level.m_7654_().m_6846_().m_11314_()) {
            ResourceLocation soundId;
            SoundEvent sound;
            double distance;
            boolean hasLineOfSight;
            if (listener.m_20148_().equals(shooter.m_20148_())) continue;
            boolean listenerInCave = ServerGunfireHandler.isInNaturalCave(level, listener.m_20183_());
            if ((shooterInCave || listenerInCave) && !(hasLineOfSight = ServerGunfireHandler.hasLineOfSight(level, listener.m_146892_(), shooterPos, (Entity)listener)) || !((distance = listener.m_20182_().m_82554_(shooterPos)) >= 50.0) || (sound = ServerGunfireHandler.getSoundForCaliber(caliberId, distance)) == null || (soundId = ForgeRegistries.SOUND_EVENTS.getKey((Object)sound)) == null) continue;
            float volume = 120.0f;
            float pitch = 0.95f + level.m_213780_().m_188501_() * 0.1f;
            long delayTicks = (long)(distance / 17.15);
            boolean playerInHouse = ServerGunfireHandler.isInHouse((Level)listener.m_284548_(), listener.m_20183_(), listener.m_146892_().f_82480_);
            PacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> listener), (Object)new PlayTrackedSoundPacket(shooterPos, soundId, volume, pitch, delayTicks, playerInHouse));
        }
    }

    private static DistanceCategory getDistanceCategory(double distance) {
        if (distance <= 200.0) {
            return DistanceCategory.CLOSE;
        }
        if (distance <= 500.0) {
            return DistanceCategory.MEDIUM;
        }
        if (distance <= 1200.0) {
            return DistanceCategory.FAR;
        }
        return DistanceCategory.SUPERFAR;
    }

    public static SoundEvent getSoundForCaliber(String caliberId, double distance) {
        DistanceCategory distCategory = ServerGunfireHandler.getDistanceCategory(distance);
        return switch (caliberId) {
            case "9mm" -> {
                switch (distCategory) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case CLOSE: {
                        yield (SoundEvent)ModSounds.CLOSE_9MM.get();
                    }
                    case MEDIUM: {
                        yield (SoundEvent)ModSounds.MEDIUM_9MM.get();
                    }
                    case FAR: {
                        yield (SoundEvent)ModSounds.FAR_9MM.get();
                    }
                    case SUPERFAR: 
                }
                yield (SoundEvent)ModSounds.SUPERFAR_9MM.get();
            }
            case "45acp" -> {
                switch (distCategory) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case CLOSE: {
                        yield (SoundEvent)ModSounds.CLOSE_45_ACP.get();
                    }
                    case MEDIUM: {
                        yield (SoundEvent)ModSounds.MEDIUM_45_ACP.get();
                    }
                    case FAR: {
                        yield (SoundEvent)ModSounds.FAR_45_ACP.get();
                    }
                    case SUPERFAR: 
                }
                yield (SoundEvent)ModSounds.SUPERFAR_45_ACP.get();
            }
            case "357mag" -> {
                switch (distCategory) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case CLOSE: {
                        yield (SoundEvent)ModSounds.CLOSE_357_MAG.get();
                    }
                    case MEDIUM: {
                        yield (SoundEvent)ModSounds.MEDIUM_357_MAG.get();
                    }
                    case FAR: {
                        yield (SoundEvent)ModSounds.FAR_357_MAG.get();
                    }
                    case SUPERFAR: 
                }
                yield (SoundEvent)ModSounds.SUPERFAR_357_MAG.get();
            }
            case "556x45" -> {
                switch (distCategory) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case CLOSE: {
                        yield (SoundEvent)ModSounds.CLOSE_5_56X45.get();
                    }
                    case MEDIUM: {
                        yield (SoundEvent)ModSounds.MEDIUM_5_56X45.get();
                    }
                    case FAR: {
                        yield (SoundEvent)ModSounds.FAR_5_56X45.get();
                    }
                    case SUPERFAR: 
                }
                yield (SoundEvent)ModSounds.SUPERFAR_5_56X45.get();
            }
            case "762x39" -> {
                switch (distCategory) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case CLOSE: {
                        yield (SoundEvent)ModSounds.CLOSE_7_62X39.get();
                    }
                    case MEDIUM: {
                        yield (SoundEvent)ModSounds.MEDIUM_7_62X39.get();
                    }
                    case FAR: {
                        yield (SoundEvent)ModSounds.FAR_7_62X39.get();
                    }
                    case SUPERFAR: 
                }
                yield (SoundEvent)ModSounds.SUPERFAR_7_62X39.get();
            }
            case "308" -> {
                switch (distCategory) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case CLOSE: {
                        yield (SoundEvent)ModSounds.CLOSE_308.get();
                    }
                    case MEDIUM: {
                        yield (SoundEvent)ModSounds.MEDIUM_308.get();
                    }
                    case FAR: {
                        yield (SoundEvent)ModSounds.FAR_308.get();
                    }
                    case SUPERFAR: 
                }
                yield (SoundEvent)ModSounds.SUPERFAR_308.get();
            }
            case "30_06" -> {
                switch (distCategory) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case CLOSE: {
                        yield (SoundEvent)ModSounds.CLOSE_30_06.get();
                    }
                    case MEDIUM: {
                        yield (SoundEvent)ModSounds.MEDIUM_30_06.get();
                    }
                    case FAR: {
                        yield (SoundEvent)ModSounds.FAR_30_06.get();
                    }
                    case SUPERFAR: 
                }
                yield (SoundEvent)ModSounds.SUPERFAR_30_06.get();
            }
            case "338" -> {
                switch (distCategory) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case CLOSE: {
                        yield (SoundEvent)ModSounds.CLOSE_338.get();
                    }
                    case MEDIUM: {
                        yield (SoundEvent)ModSounds.MEDIUM_338.get();
                    }
                    case FAR: {
                        yield (SoundEvent)ModSounds.FAR_338.get();
                    }
                    case SUPERFAR: 
                }
                yield (SoundEvent)ModSounds.SUPERFAR_338.get();
            }
            case "45_70" -> {
                switch (distCategory) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case CLOSE: {
                        yield (SoundEvent)ModSounds.CLOSE_45_70.get();
                    }
                    case MEDIUM: {
                        yield (SoundEvent)ModSounds.MEDIUM_45_70.get();
                    }
                    case FAR: {
                        yield (SoundEvent)ModSounds.FAR_45_70.get();
                    }
                    case SUPERFAR: 
                }
                yield (SoundEvent)ModSounds.SUPERFAR_45_70.get();
            }
            case "50bmg" -> {
                switch (distCategory) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case CLOSE: {
                        yield (SoundEvent)ModSounds.CLOSE_50_BMG.get();
                    }
                    case MEDIUM: {
                        yield (SoundEvent)ModSounds.MEDIUM_50_BMG.get();
                    }
                    case FAR: {
                        yield (SoundEvent)ModSounds.FAR_50_BMG.get();
                    }
                    case SUPERFAR: 
                }
                yield (SoundEvent)ModSounds.SUPERFAR_50_BMG.get();
            }
            case "50ae" -> {
                switch (distCategory) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case CLOSE: {
                        yield (SoundEvent)ModSounds.CLOSE_50_AE.get();
                    }
                    case MEDIUM: {
                        yield (SoundEvent)ModSounds.MEDIUM_50_AE.get();
                    }
                    case FAR: {
                        yield (SoundEvent)ModSounds.FAR_50_AE.get();
                    }
                    case SUPERFAR: 
                }
                yield (SoundEvent)ModSounds.SUPERFAR_50_AE.get();
            }
            case "12g" -> {
                switch (distCategory) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case CLOSE: {
                        yield (SoundEvent)ModSounds.CLOSE_12G.get();
                    }
                    case MEDIUM: {
                        yield (SoundEvent)ModSounds.MEDIUM_12G.get();
                    }
                    case FAR: {
                        yield (SoundEvent)ModSounds.FAR_12G.get();
                    }
                    case SUPERFAR: 
                }
                yield (SoundEvent)ModSounds.SUPERFAR_12G.get();
            }
            default -> null;
        };
    }

    public static boolean hasLineOfSight(Level level, Vec3 startPos, Vec3 endPos, Entity entityContext) {
        if (startPos.equals((Object)endPos)) {
            return true;
        }
        ClipContext clipContext = new ClipContext(startPos, endPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, entityContext);
        BlockHitResult hitResult = level.m_45547_(clipContext);
        return hitResult.m_6662_() == HitResult.Type.MISS;
    }

    public static boolean isInNaturalCave(Level level, BlockPos pos) {
        if (level.m_5776_()) {
            return false;
        }
        if (level.m_45527_(pos.m_7494_())) {
            return false;
        }
        if (pos.m_123342_() > level.m_5736_() - 5) {
            return false;
        }
        int skyLight = level.m_5518_().m_75814_(LightLayer.SKY).m_7768_(pos);
        return skyLight < 4;
    }

    public static boolean isInHouse(Level level, BlockPos origin, double playerEyeY) {
        if (level.m_5776_() || level.m_46472_() == Level.f_46430_ || level.m_45527_(origin)) {
            return false;
        }
        if (origin.m_123342_() < level.m_5736_() - 10 && level.m_46472_() == Level.f_46428_) {
            return false;
        }
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos(origin.m_123341_(), (int)playerEyeY, origin.m_123343_());
        int solidBlocksAbove = 0;
        for (int i = 0; i < 15; ++i) {
            mutablePos.m_122173_(Direction.UP);
            if (!level.m_46749_((BlockPos)mutablePos)) break;
            BlockState state = level.m_8055_((BlockPos)mutablePos);
            if (state.m_280296_() && !state.m_60713_(Blocks.f_50752_)) {
                ++solidBlocksAbove;
            }
            if (solidBlocksAbove < 2) continue;
            return true;
        }
        return false;
    }

    private static enum DistanceCategory {
        CLOSE,
        MEDIUM,
        FAR,
        SUPERFAR;

    }
}

